/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.CreateFlatWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.FlatLayerInfo;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlatPresetsScreen
extends Screen {
    private static final Logger field_238631_a_ = LogManager.getLogger();
    private static final List<LayerItem> field_146431_f = Lists.newArrayList();
    private final CreateFlatWorldScreen field_146432_g;
    private ITextComponent field_146439_i;
    private ITextComponent field_146436_r;
    private SlotList field_146435_s;
    private Button field_146434_t;
    private TextFieldWidget field_146433_u;
    private FlatGenerationSettings field_241594_u_;

    public FlatPresetsScreen(CreateFlatWorldScreen createFlatWorldScreen) {
        super(new TranslationTextComponent("createWorld.customize.presets.title"));
        this.field_146432_g = createFlatWorldScreen;
    }

    @Nullable
    private static FlatLayerInfo func_238638_a_(String string, int n2) {
        int n2;
        int n3;
        String[] stringArray = string.split("\\*", 2);
        if (stringArray.length == 2) {
            try {
                n3 = Math.max(Integer.parseInt(stringArray[0]), 0);
            }
            catch (NumberFormatException numberFormatException) {
                field_238631_a_.error("Error while parsing flat world string => {}", (Object)numberFormatException.getMessage());
                return null;
            }
        } else {
            n3 = 1;
        }
        \u2603 = Math.min(n2 + n3, 256);
        \u2603 = \u2603 - n2;
        String \u26032 = stringArray[stringArray.length - 1];
        try {
            Block block = Registry.field_212618_g.func_241873_b(new ResourceLocation(\u26032)).orElse(null);
        }
        catch (Exception exception) {
            field_238631_a_.error("Error while parsing flat world string => {}", (Object)exception.getMessage());
            return null;
        }
        if (block == null) {
            field_238631_a_.error("Error while parsing flat world string => Unknown block, {}", (Object)\u26032);
            return null;
        }
        FlatLayerInfo flatLayerInfo = new FlatLayerInfo(\u2603, block);
        flatLayerInfo.func_82660_d(n2);
        return flatLayerInfo;
    }

    private static List<FlatLayerInfo> func_238637_a_(String string) {
        ArrayList arrayList = Lists.newArrayList();
        String[] \u26032 = string.split(",");
        int \u26033 = 0;
        for (String string2 : \u26032) {
            FlatLayerInfo flatLayerInfo = FlatPresetsScreen.func_238638_a_(string2, \u26033);
            if (flatLayerInfo == null) {
                return Collections.emptyList();
            }
            arrayList.add(flatLayerInfo);
            \u26033 += flatLayerInfo.func_82657_a();
        }
        return arrayList;
    }

    public static FlatGenerationSettings func_243299_a(Registry<Biome> registry, String string, FlatGenerationSettings flatGenerationSettings) {
        Object object;
        Iterator iterator = Splitter.on((char)';').split((CharSequence)string).iterator();
        if (!iterator.hasNext()) {
            return FlatGenerationSettings.func_242869_a(registry);
        }
        List<FlatLayerInfo> \u26032 = FlatPresetsScreen.func_238637_a_((String)iterator.next());
        if (\u26032.isEmpty()) {
            return FlatGenerationSettings.func_242869_a(registry);
        }
        FlatGenerationSettings \u26033 = flatGenerationSettings.func_241527_a_(\u26032, flatGenerationSettings.func_236943_d_());
        RegistryKey<Biome> \u26034 = Biomes.field_76772_c;
        if (iterator.hasNext()) {
            try {
                object = new ResourceLocation((String)iterator.next());
                \u26034 = RegistryKey.func_240903_a_(Registry.field_239720_u_, (ResourceLocation)object);
                registry.func_243575_c(\u26034).orElseThrow(() -> FlatPresetsScreen.func_238641_a_((ResourceLocation)object));
            }
            catch (Exception exception) {
                field_238631_a_.error("Error while parsing flat world string => {}", (Object)exception.getMessage());
            }
        }
        object = \u26034;
        \u26033.func_242870_a(() -> (Biome)registry.func_243576_d((RegistryKey<Biome>)object));
        return \u26033;
    }

    private static String func_243303_b(Registry<Biome> registry, FlatGenerationSettings flatGenerationSettings) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < flatGenerationSettings.func_82650_c().size(); ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(flatGenerationSettings.func_82650_c().get(i));
        }
        stringBuilder.append(";");
        stringBuilder.append(registry.func_177774_c(flatGenerationSettings.func_82648_a()));
        return stringBuilder.toString();
    }

    @Override
    protected void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.field_146439_i = new TranslationTextComponent("createWorld.customize.presets.share");
        this.field_146436_r = new TranslationTextComponent("createWorld.customize.presets.list");
        this.field_146433_u = new TextFieldWidget(this.field_230712_o_, 50, 40, this.field_230708_k_ - 100, 20, this.field_146439_i);
        this.field_146433_u.func_146203_f(1230);
        MutableRegistry<Biome> mutableRegistry = this.field_146432_g.field_146385_f.field_238934_c_.func_239055_b_().func_243612_b(Registry.field_239720_u_);
        this.field_146433_u.func_146180_a(FlatPresetsScreen.func_243303_b(mutableRegistry, this.field_146432_g.func_238603_g_()));
        this.field_241594_u_ = this.field_146432_g.func_238603_g_();
        this.field_230705_e_.add(this.field_146433_u);
        this.field_146435_s = new SlotList();
        this.field_230705_e_.add(this.field_146435_s);
        this.field_146434_t = this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 155, this.field_230709_l_ - 28, 150, 20, new TranslationTextComponent("createWorld.customize.presets.select"), button -> {
            FlatGenerationSettings flatGenerationSettings = FlatPresetsScreen.func_243299_a(mutableRegistry, this.field_146433_u.func_146179_b(), this.field_241594_u_);
            this.field_146432_g.func_238602_a_(flatGenerationSettings);
            this.field_230706_i_.func_147108_a(this.field_146432_g);
        }));
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 + 5, this.field_230709_l_ - 28, 150, 20, DialogTexts.field_240633_d_, button -> this.field_230706_i_.func_147108_a(this.field_146432_g)));
        this.func_213074_a(this.field_146435_s.func_230958_g_() != null);
    }

    @Override
    public boolean func_231043_a_(double d, double d2, double d3) {
        return this.field_146435_s.func_231043_a_(d, d2, d3);
    }

    @Override
    public void func_231152_a_(Minecraft minecraft, int n, int n2) {
        String string = this.field_146433_u.func_146179_b();
        this.func_231158_b_(minecraft, n, n2);
        this.field_146433_u.func_146180_a(string);
    }

    @Override
    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a(this.field_146432_g);
    }

    @Override
    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int n, int n2, float f) {
        this.func_230446_a_(matrixStack);
        this.field_146435_s.func_230430_a_(matrixStack, n, n2, f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef(0.0f, 0.0f, 400.0f);
        FlatPresetsScreen.func_238472_a_(matrixStack, this.field_230712_o_, this.field_230704_d_, this.field_230708_k_ / 2, 8, 0xFFFFFF);
        FlatPresetsScreen.func_238475_b_(matrixStack, this.field_230712_o_, this.field_146439_i, 50, 30, 0xA0A0A0);
        FlatPresetsScreen.func_238475_b_(matrixStack, this.field_230712_o_, this.field_146436_r, 50, 70, 0xA0A0A0);
        RenderSystem.popMatrix();
        this.field_146433_u.func_230430_a_(matrixStack, n, n2, f);
        super.func_230430_a_(matrixStack, n, n2, f);
    }

    @Override
    public void func_231023_e_() {
        this.field_146433_u.func_146178_a();
        super.func_231023_e_();
    }

    public void func_213074_a(boolean bl) {
        this.field_146434_t.field_230693_o_ = bl || this.field_146433_u.func_146179_b().length() > 1;
    }

    private static void func_238640_a_(ITextComponent iTextComponent, IItemProvider iItemProvider, RegistryKey<Biome> registryKey, List<Structure<?>> list, boolean bl, boolean bl2, boolean bl3, FlatLayerInfo ... flatLayerInfoArray) {
        field_146431_f.add(new LayerItem(iItemProvider.func_199767_j(), iTextComponent, registry2 -> {
            Registry registry2;
            boolean bl4;
            Object \u260332;
            HashMap hashMap = Maps.newHashMap();
            for (Object \u260332 : list) {
                hashMap.put(\u260332, DimensionStructuresSettings.field_236191_b_.get(\u260332));
            }
            DimensionStructuresSettings \u26032 = new DimensionStructuresSettings(bl ? Optional.of(DimensionStructuresSettings.field_236192_c_) : Optional.empty(), hashMap);
            \u260332 = new FlatGenerationSettings(\u26032, (Registry<Biome>)registry2);
            if (bl2) {
                ((FlatGenerationSettings)\u260332).func_236936_a_();
            }
            if (bl3) {
                ((FlatGenerationSettings)\u260332).func_236941_b_();
            }
            for (int i = flatLayerInfoArray.length - 1; i >= 0; --i) {
                ((FlatGenerationSettings)\u260332).func_82650_c().add(flatLayerInfoArray[i]);
            }
            ((FlatGenerationSettings)\u260332).func_242870_a(() -> (Biome)registry2.func_243576_d(registryKey));
            ((FlatGenerationSettings)\u260332).func_82645_d();
            return ((FlatGenerationSettings)\u260332).func_236937_a_(\u26032);
        }));
    }

    private static /* synthetic */ IllegalArgumentException func_238641_a_(ResourceLocation resourceLocation) {
        return new IllegalArgumentException("Invalid Biome: " + resourceLocation);
    }

    static {
        FlatPresetsScreen.func_238640_a_(new TranslationTextComponent("createWorld.customize.preset.classic_flat"), Blocks.field_196658_i, Biomes.field_76772_c, Arrays.asList(Structure.field_236381_q_), false, false, false, new FlatLayerInfo(1, Blocks.field_196658_i), new FlatLayerInfo(2, Blocks.field_150346_d), new FlatLayerInfo(1, Blocks.field_150357_h));
        FlatPresetsScreen.func_238640_a_(new TranslationTextComponent("createWorld.customize.preset.tunnelers_dream"), Blocks.field_150348_b, Biomes.field_76770_e, Arrays.asList(Structure.field_236367_c_), true, true, false, new FlatLayerInfo(1, Blocks.field_196658_i), new FlatLayerInfo(5, Blocks.field_150346_d), new FlatLayerInfo(230, Blocks.field_150348_b), new FlatLayerInfo(1, Blocks.field_150357_h));
        FlatPresetsScreen.func_238640_a_(new TranslationTextComponent("createWorld.customize.preset.water_world"), Items.field_151131_as, Biomes.field_150575_M, Arrays.asList(Structure.field_236377_m_, Structure.field_236373_i_, Structure.field_236376_l_), false, false, false, new FlatLayerInfo(90, Blocks.field_150355_j), new FlatLayerInfo(5, Blocks.field_150354_m), new FlatLayerInfo(5, Blocks.field_150346_d), new FlatLayerInfo(5, Blocks.field_150348_b), new FlatLayerInfo(1, Blocks.field_150357_h));
        FlatPresetsScreen.func_238640_a_(new TranslationTextComponent("createWorld.customize.preset.overworld"), Blocks.field_150349_c, Biomes.field_76772_c, Arrays.asList(Structure.field_236381_q_, Structure.field_236367_c_, Structure.field_236366_b_, Structure.field_236372_h_), true, true, true, new FlatLayerInfo(1, Blocks.field_196658_i), new FlatLayerInfo(3, Blocks.field_150346_d), new FlatLayerInfo(59, Blocks.field_150348_b), new FlatLayerInfo(1, Blocks.field_150357_h));
        FlatPresetsScreen.func_238640_a_(new TranslationTextComponent("createWorld.customize.preset.snowy_kingdom"), Blocks.field_150433_aE, Biomes.field_76774_n, Arrays.asList(Structure.field_236381_q_, Structure.field_236371_g_), false, false, false, new FlatLayerInfo(1, Blocks.field_150433_aE), new FlatLayerInfo(1, Blocks.field_196658_i), new FlatLayerInfo(3, Blocks.field_150346_d), new FlatLayerInfo(59, Blocks.field_150348_b), new FlatLayerInfo(1, Blocks.field_150357_h));
        FlatPresetsScreen.func_238640_a_(new TranslationTextComponent("createWorld.customize.preset.bottomless_pit"), Items.field_151008_G, Biomes.field_76772_c, Arrays.asList(Structure.field_236381_q_), false, false, false, new FlatLayerInfo(1, Blocks.field_196658_i), new FlatLayerInfo(3, Blocks.field_150346_d), new FlatLayerInfo(2, Blocks.field_150347_e));
        FlatPresetsScreen.func_238640_a_(new TranslationTextComponent("createWorld.customize.preset.desert"), Blocks.field_150354_m, Biomes.field_76769_d, Arrays.asList(Structure.field_236381_q_, Structure.field_236370_f_, Structure.field_236367_c_), true, true, false, new FlatLayerInfo(8, Blocks.field_150354_m), new FlatLayerInfo(52, Blocks.field_150322_A), new FlatLayerInfo(3, Blocks.field_150348_b), new FlatLayerInfo(1, Blocks.field_150357_h));
        FlatPresetsScreen.func_238640_a_(new TranslationTextComponent("createWorld.customize.preset.redstone_ready"), Items.field_151137_ax, Biomes.field_76769_d, Collections.emptyList(), false, false, false, new FlatLayerInfo(52, Blocks.field_150322_A), new FlatLayerInfo(3, Blocks.field_150348_b), new FlatLayerInfo(1, Blocks.field_150357_h));
        FlatPresetsScreen.func_238640_a_(new TranslationTextComponent("createWorld.customize.preset.the_void"), Blocks.field_180401_cv, Biomes.field_185440_P, Collections.emptyList(), false, true, false, new FlatLayerInfo(1, Blocks.field_150350_a));
    }

    static class LayerItem {
        public final Item field_148234_a;
        public final ITextComponent field_148232_b;
        public final Function<Registry<Biome>, FlatGenerationSettings> field_238643_c_;

        public LayerItem(Item item, ITextComponent iTextComponent, Function<Registry<Biome>, FlatGenerationSettings> function) {
            this.field_148234_a = item;
            this.field_148232_b = iTextComponent;
            this.field_238643_c_ = function;
        }

        public ITextComponent func_238644_a_() {
            return this.field_148232_b;
        }
    }

    class SlotList
    extends ExtendedList<PresetEntry> {
        public SlotList() {
            super(FlatPresetsScreen.this.field_230706_i_, FlatPresetsScreen.this.field_230708_k_, FlatPresetsScreen.this.field_230709_l_, 80, FlatPresetsScreen.this.field_230709_l_ - 37, 24);
            for (int i = 0; i < field_146431_f.size(); ++i) {
                this.func_230513_b_(new PresetEntry());
            }
        }

        @Override
        public void func_241215_a_(@Nullable PresetEntry presetEntry) {
            super.func_241215_a_(presetEntry);
            if (presetEntry != null) {
                NarratorChatListener.field_193643_a.func_216864_a(new TranslationTextComponent("narrator.select", ((LayerItem)field_146431_f.get(this.func_231039_at__().indexOf(presetEntry))).func_238644_a_()).getString());
            }
            FlatPresetsScreen.this.func_213074_a(presetEntry != null);
        }

        @Override
        protected boolean func_230971_aw__() {
            return FlatPresetsScreen.this.func_241217_q_() == this;
        }

        @Override
        public boolean func_231046_a_(int n, int n2, int n3) {
            if (super.func_231046_a_(n, n2, n3)) {
                return true;
            }
            if ((n == 257 || n == 335) && this.func_230958_g_() != null) {
                ((PresetEntry)this.func_230958_g_()).func_214399_a();
            }
            return false;
        }

        public class PresetEntry
        extends ExtendedList.AbstractListEntry<PresetEntry> {
            @Override
            public void func_230432_a_(MatrixStack matrixStack, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
                LayerItem layerItem = (LayerItem)field_146431_f.get(n);
                this.func_238647_a_(matrixStack, n3, n2, layerItem.field_148234_a);
                FlatPresetsScreen.this.field_230712_o_.func_243248_b(matrixStack, layerItem.field_148232_b, n3 + 18 + 5, n2 + 6, 0xFFFFFF);
            }

            @Override
            public boolean func_231044_a_(double d, double d2, int n) {
                if (n == 0) {
                    this.func_214399_a();
                }
                return false;
            }

            private void func_214399_a() {
                SlotList.this.func_241215_a_(this);
                LayerItem layerItem = (LayerItem)field_146431_f.get(SlotList.this.func_231039_at__().indexOf(this));
                MutableRegistry<Biome> \u26032 = ((FlatPresetsScreen)FlatPresetsScreen.this).field_146432_g.field_146385_f.field_238934_c_.func_239055_b_().func_243612_b(Registry.field_239720_u_);
                FlatPresetsScreen.this.field_241594_u_ = layerItem.field_238643_c_.apply(\u26032);
                FlatPresetsScreen.this.field_146433_u.func_146180_a(FlatPresetsScreen.func_243303_b(\u26032, FlatPresetsScreen.this.field_241594_u_));
                FlatPresetsScreen.this.field_146433_u.func_146196_d();
            }

            private void func_238647_a_(MatrixStack matrixStack, int n, int n2, Item item) {
                this.func_238646_a_(matrixStack, n + 1, n2 + 1);
                RenderSystem.enableRescaleNormal();
                FlatPresetsScreen.this.field_230707_j_.func_175042_a(new ItemStack(item), n + 2, n2 + 2);
                RenderSystem.disableRescaleNormal();
            }

            private void func_238646_a_(MatrixStack matrixStack, int n, int n2) {
                RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
                SlotList.this.field_230668_b_.func_110434_K().func_110577_a(AbstractGui.field_230664_g_);
                AbstractGui.func_238464_a_(matrixStack, n, n2, FlatPresetsScreen.this.func_230927_p_(), 0.0f, 0.0f, 18, 18, 128, 128);
            }
        }
    }
}

